; TFT-Display MAR3501 initialisieren

.include "allgdef.inc"

.global	Lcdinit,Commandozumtft,Datenzumtft

Lcdinit:
	call	Test
	call	Lcdreset
	
	mov		#0xf7,w1		; Power Control
	mov		#0xa9,w2
	mov		#0x51,w3
	mov		#0x2c,w4
	mov		#0x82,w5
	rcall	Zumtft5byte
	
	mov		#0xc0,w1		; Power2 Control
	mov		#0x11,w2
	mov		#0x09,w3
	rcall	Zumtft3byte

   	mov		#0xC1,w1  		; Power3 Control Normal Mode
	mov		#0x41,w2
	rcall	Zumtft2byte

	mov		#0xC5,w1		; VCOM Control 1
	mov		#0x00,w2
	mov		#0x0a,w3
	mov		#0x80,w4
	rcall	Zumtft4byte

	mov		#0xb1,w1		; Fram Rate Control
	mov		#0xb0,w2
	mov		#0x11,w3
	rcall	Zumtft3byte

   	mov		#0xb4,w1      	; Inversion Control
	mov		#0x02,w2
	rcall	Zumtft2byte

	mov		#0xb6,w1		; Function Control
	mov		#0x00,w2
	mov		#0x42,w3
	mov		#0x3b,w4
	rcall	Zumtft3byte

   	mov		#0xb7,w1      	; Entry Mode Set
	mov		#0xc6,w2
	rcall	Zumtft2byte

	mov		#0xbe,w1		; VCOM Control 1
	mov		#0x00,w2
	mov		#0x04,w3
	rcall	Zumtft3byte

	mov		#0xe9,w1		; VCOM Control 1
	mov		#0x00,w2
	rcall	Zumtft2byte

	mov		#0x36,w1		; VCOM Control 1
	mov		#0x68,w2
	rcall	Zumtft2byte
	
	mov		#0x3a,w1		; VCOM Control 1
	mov		#0x55,w2
	rcall	Zumtft2byte


	mov		#15,w6
	mov		#psvoffset(posgamma),w5
	call	Zumtftinitstring
	call	Test

	mov		#15,w6
	mov		#psvoffset(neggamma),w5
	call	Zumtftinitstring
	
 
	mov		#0x11,w1       	; Sleep  out
	rcall	Commandozumtft
	bset	LATA,#lcd_cs

	rcall	Warten100ms
	rcall	Warten100ms
	call	Test
	
	mov		#0x29,w1  		; Display ON
	rcall	Commandozumtft
	bset	LATA,#lcd_cs
	rcall	Warten100ms
	call	Test
	return

Test:
	nop
	nop
	nop
	nop
	return
	
;-----------------------------------------------------
; div. UPs
;-----------------------------------------------------
			
; Eingang: w5 = Adresse der Daten-Tabelle, w6 = Anzahl der Byte excl. Befehl
Zumtftinitstring:
	mov		[w5++],w1
	rcall	Commandozumtft
zumtfti1:
	mov		[w5++],w1
	rcall	Datenzumtft
	dec		w6,w6
	bra		nz,zumtfti1
	bset	LATA,#lcd_cs
	return

; Eingang: w1=Befehl, w2 = Daten	
Zumtft2byte:
	rcall	Commandozumtft
	mov		w2,w1
	rcall	Datenzumtft
	bset	LATA,#lcd_cs
	return
	
; Eingang: w1=Befehl, w2, w3 = Daten	
Zumtft3byte:
	rcall	Commandozumtft
	mov		w2,w1
	rcall	Datenzumtft
	mov		w3,w1
	rcall	Datenzumtft
	bset	LATA,#lcd_cs
	return

; Eingang: w1=Befehl, w2, w3, w4  = Daten	
Zumtft4byte:
	rcall	Commandozumtft
	mov		w2,w1
	rcall	Datenzumtft
	mov		w3,w1
	rcall	Datenzumtft
	mov		w4,w1
	rcall	Datenzumtft
	bset	LATA,#lcd_cs
	return

; Eingang: w1=Befehl, w2, w3, w4,w5  = Daten	
Zumtft5byte:
	rcall	Commandozumtft
	mov		w2,w1
	rcall	Datenzumtft
	mov		w3,w1
	rcall	Datenzumtft
	mov		w4,w1
	rcall	Datenzumtft
	mov		w5,w1
	rcall	Datenzumtft

	bset	LATA,#lcd_cs
	return
	
; Eingang: 	Befehl in w1
; Ausgang:	lcd_cs noch aktiv
  Commandozumtft:
	mov		LATB,w0
	swap	w0
	and		#0xff,w0
	swap	w0
	ior		w0,w1,w0
	mov		w0,LATB
	nop 
	bclr	LATA,#lcd_cs
	bclr	LATB,#lcd_rs
	bclr	LATB,#lcd_wr
	bset	LATB,#lcd_wr
	bset	LATB,#lcd_rs
	return	

; Eingang: 	Befehl in w1 im NW, HW = 00
; Ausgang:	lcd_CS noch aktiv
Datenzumtft:
	mov		LATB,w0
	swap	w0
	and		#0xff,w0
	swap	w0
	ior		w0,w1,w0
	mov		w0,LATB
	nop 
zumtft1: 
 	bclr	LATB,#lcd_wr
	bset	LATB,#lcd_wr
	return	
	
Lcdreset:
	bclr	LATA,#lcd_rst
	call	Warten100ms
	bset	LATA,#lcd_rst
	call	Warten100ms
	return

Warten100ms:
	mov		#100,w0
w100ms1:
	call	warten1ms
	dec		w0,w0
	bra		nz,w100ms1
	return
warten1ms:
	mov		#2600,w1
w1ms1:
	nop
	dec		w1,w1
	bra		nz,w1ms1
	return

		